hvClient = {}
Tunnel.bindInterface(GetCurrentResourceName(), hvClient)

function hvClient.getPosition()
    return GetEntityCoords(PlayerPedId())
end

RegisterNetEvent(Settings.Notify.EventName)
AddEventHandler(Settings.Notify.EventName,function(type, title, message, time)
    if not time then 
        time = Settings.Notify.DefaultTime
    end

    if Settings.Notify.Debug then
        if not type or not title or not message or not time then
            print("[type]" .. type .. "[title]" .. title .. "[message]" .. message .. "[time]" .. time)    
        end
    end

    SendNUIMessage({ 
        action = "notify", 
        type = type, 
        title = title, 
        message = message, 
        time = time
    })
end)

local notifys = {}
RegisterNetEvent(Settings.Position.EventName)
AddEventHandler(Settings.Position.EventName,function(x, y, z, message, user_id)
    SendNUIMessage({ 
        action = "notify", 
        type = 'policia', 
        title = "Policia", 
        message = message,
        time = Settings.Notify.DefaultTime
    })

    if not DoesBlipExist(notifys[user_id]) then
        notifys[user_id] = AddBlipForCoord(x,y,z)

        PlaySoundFrontend(-1,"Enter_1st","GTAO_FM_Events_Soundset", false)

        SetBlipScale(notifys[user_id], 0.5)
        SetBlipSprite(notifys[user_id], 10)
        SetBlipColour(notifys[user_id], 49)

        BeginTextCommandSetBlipName("STRING")
        AddTextComponentString("Posição atualizada")

        EndTextCommandSetBlipName(notifys[user_id])

        SetBlipAsShortRange(notifys[user_id], false)

        SetTimeout(20000,function()
            if DoesBlipExist(notifys[user_id]) then
                RemoveBlip(notifys[user_id])
            end
        end)
    end
end)

RegisterNetEvent(Settings.ItemNotify.EventName)
AddEventHandler(Settings.ItemNotify.EventName,function(type, index, name, amount)
    if Settings.ItemNotify.Debug then
        if not type or not index or not name or not amount then
            print("[type]" .. type .. "[index]" .. index .. "[name]" .. name .. "[amount]" .. amount)    
        end
    end

    SendNUIMessage({ 
        action = "itemNotify", 
        type = type, 
        index = index, 
        name = name, 
        amount = amount,
        time = Settings.ItemNotify.DefaultTime
    })
end)

RegisterNetEvent(Settings.Announce.EventName)
AddEventHandler(Settings.Announce.EventName,function(title, message, author, time)
    if Settings.Announce.Debug then
        if not title or not message or not author or not time then
            print("[title]" .. title .. "[message]" .. message .. "[author]" .. author .. "[time]" .. time)    
        end
    end

    SendNUIMessage({ 
        action = "announce", 
        title = title, 
        message = message, 
        author = author, 
        time = time
    })
end)

RegisterNetEvent(Settings.Announce.Delete.EventName)
AddEventHandler(Settings.Announce.Delete.EventName,function()
    SendNUIMessage({ action = "deleteAnnounce" })
end)